#include "neighbour_joining_operation.hpp"
#include "neighbour_joining_data.hpp"
#include "operation_accessors.hpp"
#include "progress_update.h"
#include "bionj_clean.h"
#include "debug.hpp"

namespace gui {
	
	NeighbourJoiningOperation::NeighbourJoiningOperation()
	: _data_for_nj(0)
	{}
	
	NeighbourJoiningOperation::~NeighbourJoiningOperation()
	{
		GUI_MSG_OBJ_DESTROYED(NeighbourJoiningOperation);
	}
	
	void NeighbourJoiningOperation::execute()
	{
		setMaximumValue(_data_for_nj->getNumMatrices());
		updateProgress(0);
		updateProgress(QObject::tr("Neighbour Joining Operation (") + _data_for_nj->name() + ")");
		
		std::vector<std::string> trees(_data_for_nj->getNumMatrices());
		std::vector<std::string> sequenceNames = _data_for_nj->getSequenceNames();
		profdist::ProgressSink sink;
		size_t counter = 0;
		
		try {
			for(std::vector<std::string>::iterator i = trees.begin(), e = trees.end(); i != e; i++)
			{
				if(isCanceled())
					return;
				std::ostringstream out;
				profdist::bionj(_data_for_nj->getDistanceMatrix(counter), sequenceNames, out, sink);
				(*i) = out.str();
				updateProgress(++counter);
			}
			
			NeighbourJoiningData* data = new NeighbourJoiningData(_data_for_nj->name() + "_nj", trees, sequenceNames);
			addDataItem(data, _data_for_nj);
		}
		catch(const error& e)
		{
			GUI_MSG_N("error during neighbour joining operation:" << std::endl << e);
		}
		catch(const std::exception& e)
		{
			GUI_MSG_N("error during neighbour joining operation:" << std::endl << e.what());
		}
		
		_data_for_nj->decrementUseCount();
	}
	
	OperationInterface* NeighbourJoiningOperation::clone()
	{
		return new NeighbourJoiningOperation();
	}
	
	bool NeighbourJoiningOperation::setDataItem(DataItem* item)
	{
		if(!item)
			return false;
		_data_for_nj = dynamic_cast<DataForNj*>(item);
		if(!_data_for_nj)
			return false;
		_data_for_nj->incrementUseCount();
		return true;
	}
	
}
