#ifndef PROFDIST_QTGUI_MAIN_WINDOW_HPP_
#define PROFDIST_QTGUI_MAIN_WINDOW_HPP_

#include <QMainWindow>
#include <QSystemTrayIcon>
#include <QList>

class QTreeView;
class QCloseEvent;
class QModelIndex;
class QToolButton;
class QActionGroup;

namespace gui {
	
	class WorkspaceTreeView;
	class Workspace;
	class ProgressSink;
	class TaskContainerWidget;
	class OperationInterface;
	class Task;
	
	class MainWindow : public QMainWindow {
			Q_OBJECT
		public:
			MainWindow();
			~MainWindow();
			
			QTreeView* workspaceTreeView();
			void trackProgressOfTask(Task* task);
			Workspace* workspace();
			void loadPlugins();
			QList<QAction*> defaultActions();
			
			enum MessageType {
				MT_ERROR,
				MT_WARNING,
				MT_QUESTION,
				MT_INFORMATION
			};
		
		public Q_SLOTS:
			void onHide();
			void onShow();
			void onQuit();
			void showMessage(const QString& message, const QString& title = tr("Error"), MessageType type = MT_ERROR);
			void ballonMessage(const QString& message);
			void ballonMessage(const QString& title, const QString& message);
			void updateFeatures();
			void aboutProfdist();
			void openUrl(const QString& url);
			void openHelp();
			void systemTrayActivated(QSystemTrayIcon::ActivationReason reason);
			
		protected:
			void doLayout();
			void createActions();
			void createMenuBar();
			void createToolBar();
			void createDockWidget();
			void createSystemTray();
			
			void closeEvent(QCloseEvent* event);
			
		private:
			WorkspaceTreeView				*_tree_view;
			
			Workspace						*_workspace;
			
			QAction							*_action_open,
											*_action_view,
											*_action_save_as,
											*_action_remove,
											*_action_rename,
											*_action_quit,
											*_action_settings,
											*_action_about,
											*_action_help,
											*_action_systray_open,
											*_action_systray_hide,
											*_action_systray_quit;
			
			QToolButton						*_tool_button_run;
			
			QSystemTrayIcon					*_system_tray_icon;
			
			QMenu							*_systray_menu;
			
			TaskContainerWidget				*_task_container_widget;
	};
	
	/**
	 * Global variable which stores the pointer to the MainWindow object.
	 */
	extern MainWindow* mainWindow;
	
}

#endif // PROFDIST_QTGUI_MAIN_WINDOW_HPP_

