#include "helper.hpp"
#include "spirit_helper.h"
#include "bdb_parser.h"
#include <boost/cstdlib.hpp>
#include <boost/spirit/phoenix.hpp>
#include <boost/spirit/core.hpp>
#include <boost/spirit/core/primitives/primitives.hpp>
#include <boost/spirit/utility/grammar_def.hpp>
#include <boost/spirit/utility/lists.hpp>
#include <boost/spirit/utility/chset.hpp>
#include <boost/spirit/iterator/file_iterator.hpp>
#include <boost/spirit/iterator/position_iterator.hpp>
#include <boost/spirit/core/composite/epsilon.hpp>
#include <boost/spirit/actor/push_back_actor.hpp>
#include <boost/spirit/actor/increment_actor.hpp>
#include <boost/spirit/actor/clear_actor.hpp>

#include <boost/spirit/symbols.hpp>
#include <boost/spirit/attribute.hpp>
#include <boost/spirit/dynamic.hpp>

namespace gui {
	
	QString alignmentToQString(const profdist::AlignCode<profdist::rna_structure_traits>& alignCode)
	{
		QString data;
		
		// Returns the alignment data as a fasta formtatted string
		for(int i = 0, max = alignCode.get_num_sequences(); i < max; i++)
		{
			data.append(">").append(alignCode.get_sequence_name(i).c_str()).append("\n");
			
#if 0
			int column = 0;
			QString tmp = "";
			for(profdist::AlignCode<profdist::rna_structure_traits>::const_sequence_iterator iter = alignCode.begin(i), end = alignCode.end(i); iter != end; iter++, column++)
			{
				if(column > 79)
				{
					data.append("\n").append(tmp).append("\n");
					tmp = "";
					column = 0;
				}
				data.append(profdist::rna_structure_traits::get_char(*iter));
				tmp.append(profdist::rna_structure_traits::get_fold_char(*iter));
			}
#endif
			
			QString tmp("");
			
			for(profdist::AlignCode<profdist::rna_structure_traits>::const_sequence_iterator iter = alignCode.begin(i), end = alignCode.end(i); iter != end; iter++)
			{
				data.append(profdist::rna_structure_traits::get_char(*iter));
				tmp.append(profdist::rna_structure_traits::get_fold_char(*iter));
			}
			
			data.append("\n").append(tmp).append("\n\n");
		}
	
		return data;
	}
	
	bool writeAlignmentToFile(std::ostream& out, const profdist::AlignCode<profdist::rna_structure_traits>& alignCode)
	{
		if(!out)
			return false;
		
		// Returns the alignment data as a fasta formtatted string
		for(int i = 0, max = alignCode.get_num_sequences(); i < max; i++)
		{
			out << ">" << alignCode.get_sequence_name(i) << std::endl;
			
#if 0
			int column = 0;
			std::string tmp = "";
			for(profdist::AlignCode<profdist::rna_structure_traits>::const_sequence_iterator iter = alignCode.begin(i), end = alignCode.end(i); iter != end; iter++, column++)
			{
				if(column > 80)
				{
					out << "\n" << tmp << "\n";
					tmp = "";
					column = 0;
				}
				out << profdist::rna_structure_traits::get_char(*iter);
				tmp.append(1, profdist::rna_structure_traits::get_fold_char(*iter));
			}
				
			out << "\n" << tmp << "\n\n";
#endif
			
			std::string tmp("");
			
			for(profdist::AlignCode<profdist::rna_structure_traits>::const_sequence_iterator iter = alignCode.begin(i), end = alignCode.end(i); iter != end; iter++)
			{
				out << profdist::rna_structure_traits::get_char(*iter);
				tmp.append(1, profdist::rna_structure_traits::get_fold_char(*iter));
			}
			
			out << std::endl << tmp << std::endl << std::endl;
		}
		
		return true;
	}
	
	void parseAlignmentFromString(char* begin, char* end, profdist::alignment& sequences, const std::string& fileName, const profdist::rna_traits&)
	{
		using boost::spirit::parse;
		using boost::spirit::parse_info;
		using boost::spirit::anychar_p;
		using boost::spirit::alpha_p;
		using boost::spirit::space_p;
		using boost::spirit::chset;
		using boost::spirit::eps_p;
		using boost::spirit::clear_a;
		using boost::spirit::push_back_a;
		using boost::spirit::assign_a;
		using boost::spirit::increment_a;
		profdist::alignment::value_type current_sequence; ///< temporary file_sequence object 
		profdist::alignment::value_type::string_range current_range; ///< temporary storage for list entries 

		parse_info<char*> info = parse( begin, end, 
			*(
				*space_p
					>> '>' 
					>> (
					*( anychar_p - chset<>("\n\r") )
						)
					[assign_a( current_sequence.id )]
					>> lf_p
					>>
					+( 
					(+((alpha_p|'-') [increment_a( current_sequence.sequence_length ) ] ) )
					[assign_a( current_range )]
					[push_back_a( current_sequence.sequence_data, current_range ) ] 
					| space_p 
						) 
					>> eps_p
					[push_back_a( sequences, current_sequence )]
					[clear_a( current_sequence )]
				)
			);

		if( !info.full )
		{
			using boost::spirit::position_iterator;
			typedef position_iterator<char*> iterator_t;

			std::ostringstream out;
			//iterator_t first( data, &data[data_size], _tmp_file_name);
			iterator_t first( begin, end, fileName.c_str());
			while( &*first != info.stop ) ++first;
			out << "Parsing failed at line " << first.get_position().line << " and column " 
					<< first.get_position().column << " in file " << /*_tmp_file_name*/ fileName.c_str()
					<< '\n' << sequences.size() << " Sequences were found.\nError happened near:\n[...]" 
					<< std::string( std::max( begin, info.stop - 20 ), std::min( end, info.stop + 20) ) << '\n';
			throw std::runtime_error( out.str() );
		}
	}
	
	void parseAlignmentFromString(char* begin, char* end, profdist::alignment& sequences, const std::string& fileName, const profdist::protein_traits&)
	{
		/*
		* Protein alilgnments can be parsed like rna alignments.
		*/
		parseAlignmentFromString(begin, end, sequences, fileName, profdist::rna_traits());
	}
	
	void parseAlignmentFromString(char* begin, char* end, profdist::alignment& sequences, const std::string& fileName, const profdist::rna_structure_traits&)
	{
		bdb_grammar grammar(sequences);
		boost::spirit::parse_info<char*> info = boost::spirit::parse( begin, end, grammar);
		
		if( !info.full )
		{
			using boost::spirit::position_iterator;
			typedef position_iterator<char*> iterator_t;

			ostringstream out;
			iterator_t first( begin, end, fileName.c_str());
			while( &*first != info.stop ) ++first;
			out << "Parsing failed at line " << first.get_position().line << " and column " 
					<< first.get_position().column << " in file " << fileName.c_str()
					<< '\n' << sequences.size() << " Sequences were found.\nError happened near:\n" 
					<< string( max( begin, info.stop - 20 ), min( end, info.stop + 20) ) << '\n';
			throw runtime_error( out.str() );
		}
	}
}
