#ifndef PROFDIST_QTGUI_GUI_HANDLE_DATA_HPP_
#define PROFDIST_QTGUI_GUI_HANDLE_DATA_HPP_

#include <set>
#include <string>
#include <QString>
#include <QIcon>

namespace gui {
	
	class Viewer;
	
	class GuiHandleData {
		public:
			virtual ~GuiHandleData();
			
		protected:
			/* member function used to enable polymorphism and downcasting. */
			virtual void misterPolymorph() = 0;
	};
	
	class PnjGuiHandleData : public GuiHandleData {
		public:
			PnjGuiHandleData();
			void misterPolymorph();
			
			/* [IN] */
			QIcon icon;
			QString alignmentName;
			std::string tree;
			Viewer* viewer;
			
			/* [OUT] */
			std::set<size_t> profiles;
	};
	
}

#endif // PROFDIST_QTGUI_GUI_HANDLE_DATA_HPP_

