#include "gui_handle.hpp"
#include "main_window.hpp"
#include "workspace.hpp"
#include "gui_handle_data.hpp"
#include "spirit_helper.h"
#include "data_type.hpp"
#include "viewer.hpp"
#include <iostream>

#include "ui_manual_profile_definition_dialog.h"

#include <QDialog>
#include <QTemporaryFile>
#include <QString>

#include <boost/spirit/core.hpp>
#include <boost/spirit/core/primitives/numerics.hpp>
#include <boost/spirit/core/primitives/primitives.hpp>
#include <boost/spirit/core/composite/kleene_star.hpp>
#include <boost/spirit/actor/push_back_actor.hpp>
#include <boost/spirit/utility/lists.hpp>
#include <boost/lexical_cast.hpp>

namespace gui {
	
	/* GuiHandle */
	int GuiHandle::_id = -1;
	bool GuiHandle::_id_set = false;
	
	GuiHandle::~GuiHandle()
	{}
	
	void GuiHandle::setGuiHandleId(int id)
	{
		if(!_id_set)
		{
			_id = id;
			_id_set = true;
		}
	}
	
	int GuiHandle::getGuiHandleId()
	{
		return _id;
	}
	
	
	/* PnjGuiHandle */
	void PnjGuiHandle::exec(GuiHandleData *data)
	{
		PnjGuiHandleData* handleData = dynamic_cast<PnjGuiHandleData*>(data);
		if(!handleData)
		{
			mainWindow->showMessage(QObject::tr("Could not open manual profile"
				" definition dialog:\ndynamic cast error"));
			return;
		}
		
		/*
		 * Now start the tree viewer
		 */
		Viewer* viewer = mainWindow->workspace()->getViewer(DataType::PnjTree);
		viewer->setData(QString(handleData->tree.c_str()));
		viewer->show(false);
		
		/*
		 * Profile definition dialog
		 */
		QDialog dia(mainWindow);
		Ui::ManualProfileDefinitionDialog dialog;
		dialog.setupUi(&dia);
		dialog.labelIcon->setPixmap(handleData->icon.pixmap(32,32));
		dialog.labelAlignmentName->setText(handleData->alignmentName);
		if(QDialog::Accepted == dia.exec())
		{
			using boost::spirit::parse;
			using boost::spirit::parse_info;
			using boost::spirit::uint_p;
			using boost::spirit::space_p;
			using boost::spirit::ch_p;
		
			parse_info<> result = parse(dialog.lineEdit->text().toStdString().c_str() , 
				uint_p[set_insert_a(handleData->profiles)] 
				>> *(
				( ch_p(' ') |  ',' |  ';')
				>> uint_p[set_insert_a(handleData->profiles)] 
				) 
				>> *
				( ch_p(' ') |  ',' |  ';' )
				,space_p
				);
		}
		if(viewer)
			delete viewer;
	}
	
	GuiHandle* PnjGuiHandle::clone()
	{
		return new PnjGuiHandle();
	}
	
}

