#ifndef PROFDIST_QTGUI_FILE_TYPE_HPP_
#define PROFDIST_QTGUI_FILE_TYPE_HPP_

#include <QString>
#include <QStringList>
#include <stdexcept>

namespace gui {
	
	class DataItem;
	class Workspace;
	
	/**
	 * Represents a file type (Fasta, Embl, etc). It can be registered at the
	 * workspace to act as the main class to handle this specific file type.
	 */
	class FileType {
		public:
			FileType(const QString& fileTypeName, const QString& suffixes);
			virtual ~FileType();
			
			/**
			 * Parses a given file and returns a DataItem object.
			 * @param workspace Workspace object for request further information
			 * or to show dialogs as child dialogs of the main window.
			 * @param fileName The name of the file to be parsed.
			 */
			virtual DataItem* parseFile(const QString& fileName) const = 0;
			
			bool containsSuffix(const QString& suffix) const;
			QStringList suffixes() const;
			QString fileDialogFilter() const;
			QString name() const;
			
			bool operator==(const FileType& fileType) const;
		
		protected:
			const QString			_file_type_name;
			const QStringList		_suffixes;
	};
	
#define DECLARE_NEW_ALIGNMENT_FILE_TYPE(name) \
	class name : public FileType { \
		public: \
			name(); \
			DataItem* parseFile(const QString& fileName) const; \
	};
	
	DECLARE_NEW_ALIGNMENT_FILE_TYPE(Fasta)
	DECLARE_NEW_ALIGNMENT_FILE_TYPE(Embl)
	DECLARE_NEW_ALIGNMENT_FILE_TYPE(XFasta)
	
	//--> Insert here new Alignment File Types
	
#undef DECLARE_NEW_ALIGNMENT_FILE_TYPE
	
}

#endif // PROFDIST_QTGUI_FILE_TYPE_HPP_

