#ifndef PROFDIST_QTGUI_FEATURE_HPP_
#define PROFDIST_QTGUI_FEATURE_HPP_

#include <QObject>
#include <QAction>
#include "data_type.hpp"

namespace gui {
	
	class Feature {
		public:
			Feature(QAction* action);
			virtual ~Feature();
			QAction* action();
			virtual bool isAvailable(unsigned int type) = 0;
			
		private:
			QAction				*_action;
	};

#define DECLARE_NEW_FEATURE(name) \
	class name : public Feature { \
		public: \
			name(); \
			bool isAvailable(unsigned int type); \
	};
	
	DECLARE_NEW_FEATURE(RnaBootstrapFeature)
	DECLARE_NEW_FEATURE(RnaStructureBootstrapFeature)
	DECLARE_NEW_FEATURE(ProteinBootstrapFeature)
	DECLARE_NEW_FEATURE(RnaDistanceFeature)
	DECLARE_NEW_FEATURE(RnaStructureDistanceFeature)
	DECLARE_NEW_FEATURE(ProteinDistanceFeature)
	DECLARE_NEW_FEATURE(NeighbourJoiningFeature)
	DECLARE_NEW_FEATURE(ConsensusFeature)
	DECLARE_NEW_FEATURE(RnaProfileNeighbourJoiningFeature)
	DECLARE_NEW_FEATURE(RnaStructureProfileNeighbourJoiningFeature)
	DECLARE_NEW_FEATURE(ProteinProfileNeighbourJoiningFeature)

#undef DECLARE_NEW_FEATURE

}

#endif // PROFDIST_QTGUI_FEATURE_HPP_

