#ifndef PROFDIST_QTGUI_DATA_ITEM_HPP_
#define PROFDIST_QTGUI_DATA_ITEM_HPP_

#include <QMutex>
#include <QIcon>
#include <QString>

#include "tree_item.hpp"
#include "types.h"
#include "data_type.hpp"
#include "viewer.hpp"

#include <boost/shared_ptr.hpp>

namespace gui {
	
	/**
	 * 
	 */
	class DataItem : public TreeItem<DataItem> {
		public:
			
										DataItem();
			virtual						~DataItem();
			
			QString						name() const;
			void						setName(const std::string& name);
			void						setName(const QString& name);
			virtual unsigned int		type() const = 0;
			virtual QIcon				icon() const;
			virtual QString				info() const;
			virtual QString				dataToString() const = 0;
			boost::shared_ptr<Viewer>	viewer() const;
			void						setViewer(Viewer* viewer);
			
			virtual bool				writeData(std::ostream& out, profdist::FileType fileType) = 0;
			
			size_t						useCount() const;
			void						incrementUseCount();
			void						decrementUseCount();
			
		private:
			QString						_name;
			size_t						_use_count;
			QMutex						_mutex_use_count;
			boost::shared_ptr<Viewer>	_viewer;
		
	};
	
}

#endif // PROFDIST_QTGUI_DATA_ITEM_HPP_

