#include "data_item.hpp"
#include "debug.hpp"
#include <QMutexLocker>

namespace gui {
	
	DataItem::DataItem()
	: _name(""), _use_count(0), _viewer()
	{}
	
	DataItem::~DataItem()
	{}
	
	QString DataItem::name() const
	{
		return _name;
	}
	
	void DataItem::setName(const std::string& name)
	{
		_name = QString(name.c_str());
	}
	
	void DataItem::setName(const QString& name)
	{
		_name = name;
	}
	
	QIcon DataItem::icon() const
	{
		return QIcon();
	}
	
	QString DataItem::info() const
	{
		return QString();
	}
	
	boost::shared_ptr<Viewer> DataItem::viewer() const
	{
		return _viewer;
	}
	
	void DataItem::setViewer(Viewer* viewer)
	{
		_viewer.reset(viewer);
	}
	
	size_t DataItem::useCount() const
	{
		return _use_count;
	}
	
	void DataItem::incrementUseCount()
	{
		QMutexLocker lock(&_mutex_use_count);
		++_use_count;
	}
	
	void DataItem::decrementUseCount()
	{
		QMutexLocker lock(&_mutex_use_count);
		if(_use_count > 0)
			--_use_count;
	}
	
}

