#include "consensus_operation.hpp"
#include "consensus_data.hpp"
#include "countedsets.h"
#include "tree.h"
#include "consense.h"
#include "debug.hpp"

#include <QTemporaryFile>

namespace gui {
	
	ConsensusOperation::ConsensusOperation()
	: _data_for_consensus(0)
	{}
	
	ConsensusOperation::~ConsensusOperation()
	{
		GUI_MSG_OBJ_DESTROYED("ConsensusOperation object destroyed");
	}
	
	void ConsensusOperation::execute()
	{
		setMaximumValue(_data_for_consensus->getNumTrees());
		
		updateProgress(0);
		
		std::vector<std::string> nj_trees = _data_for_consensus->getTrees();
		std::list<profdist::parsed_node::node_ptr> trees; // Stores all 
		std::vector<std::string> names;
		int counter = 0;
		
		typedef std::vector<std::string> nj_trees_t;
		typedef std::list<profdist::parsed_node::node_ptr> trees_t;
		
		try
		{
			updateProgress(QObject::tr("Generating Consensus Tree (Parsing Trees)"));
			std::ostringstream out1;
			_data_for_consensus->writeData(out1, profdist::Fasta);
			
			/*QTemporaryFile file("profdist_consensus_XXXXXX.txt");
			if(!file.open())
				throw std::runtime_error("Could not open temprorary file '" + file.fileName().toStdString() + "'");
			std::string fileName = file.fileName().toStdString();
			file.write(out1.str().c_str(), out1.str().size());
			file.close();*/
			
			parse_newick_from_string(out1.str(), trees, names);
			
			/*
			for(nj_trees_t::const_iterator i = nj_trees.begin(), e = nj_trees.end(); i != e; i++)
			{
				if(isCanceled())
					return;
				QTemporaryFile file("profdist_consensus_XXXXXX.txt");
				if(!file.open())
					throw std::runtime_error("Could not open temprorary file '" + file.fileName().toStdString() + "'");
				std::string fileName = file.fileName().toStdString();
				file.write((*i).c_str(), (*i).size());
				file.close();
				parse_newick(fileName, trees, names);
				updateProgress(++counter);
			}
			*/
			
			CountedSets countedSets;
			
			updateProgress(QObject::tr("Generating Consensus Tree (Computing splits)"));
			for(trees_t::const_iterator i = trees.begin(), e = trees.end(); i != e; i++)
			{
				if(isCanceled())
					return;
				profdist::get_splits(**i, countedSets, names.size());
				updateProgress(++counter);
			}
			
			countedSets.consense(names.size());
			Tree tree(countedSets, names.size(), trees.size());
			std::ostringstream out2;
			tree.print( out2, names, trees.size() );
			out2 << std::endl;
			out2.flush();
		
			ConsensusData* consensusData = new ConsensusData(_data_for_consensus->name() + "_consensus", out2.str());
			addDataItem(consensusData, _data_for_consensus);
		}
		catch(const error& e)
		{
			GUI_MSG_N("Error during consensus operation:" << std::endl << e);
			showErrorMessage(QObject::tr("Error during consensus operation:\n") + QString(e));
		}
		catch(const exception& e)
		{
			GUI_MSG_N("Error during consensus operation:" << std::endl << e.what());
			showErrorMessage(QObject::tr("Error during consensus operation:\n") + QString(e.what()));
		}
		
		_data_for_consensus->decrementUseCount();
	}
	
	bool ConsensusOperation::setDataItem(DataItem* item)
	{
		if(!item)
			return false;
		
		_data_for_consensus = dynamic_cast<DataForConsensus*>(item);
		if(!_data_for_consensus)
			return false;
		_data_for_consensus->incrementUseCount();
		return true;
	}
	
	OperationInterface* ConsensusOperation::clone()
	{
		return new ConsensusOperation();
	}
	
}
