#include "consensus_data.hpp"
#include "data_type.hpp"
#include "debug.hpp"

namespace gui {
	
	ConsensusData::ConsensusData(const QString& name, const std::string& trees)
	: _trees(trees)
	{
		this->setName(name);
	}
	
	ConsensusData::~ConsensusData()
	{
		GUI_MSG_N("ConsensusData object destroyed");
	}
	
	unsigned int ConsensusData::type() const
	{
		return DataType::ConsensusTree;
	}
	
	QIcon ConsensusData::icon() const
	{
		return QIcon(":/images/64x64/tree.png");
	}
	
	QString ConsensusData::info() const
	{
		return QObject::tr("Consensus Tree");
	}
	
	QString ConsensusData::dataToString() const
	{
		return QString(_trees.c_str());
	}
	
	bool ConsensusData::writeData(std::ostream& out, profdist::FileType type)
	{
		out << _trees << std::endl;
		return true;
	}
	
}
