#include "classification_data.hpp"
#include "parsed_alignment.hpp"
#include "parsed_sequence.h"

namespace gui {
	
	classification_t getClassificationData(const profdist::alignment& sequences)
	{
		typedef profdist::alignment::const_iterator iter;
		typedef std::list<profdist::alignment::value_type::string_range> string_range_list;
		
		classification_t data;
		
		for(iter i = sequences.begin(), e = sequences.end(); i != e; i++)
		{
			std::list<std::string> tmp_data;
			
			for(string_range_list::const_iterator k = i->classification.begin(),
				k_e = i->classification.end(); k != k_e; k++)
			{
				tmp_data.push_back(std::string(k->first, k->second));
			}
			
			data.push_back(tmp_data);
		}
		
		return data;
	}
	
}

