#include "bootstrap_data.hpp"
#include "data_type.hpp"

namespace gui {
	
	template<>
	unsigned int BootstrapData<profdist::rna_traits>::type() const
	{
		return DataType::RnaBootstrap;
	}
	
	template<>
	unsigned int BootstrapData<profdist::rna_structure_traits>::type() const
	{
		return DataType::RnaStructureBootstrap;
	}
	
	template<>
	unsigned int BootstrapData<profdist::protein_traits>::type() const
	{
		return DataType::ProteinBootstrap;
	}
	
	template<> QIcon BootstrapData<profdist::rna_traits>::icon() const
	{
		return QIcon(":images/64x64/rna_bootstrap.png");
	}
	
	template<> QIcon BootstrapData<profdist::rna_structure_traits>::icon() const
	{
		return QIcon(":images/64x64/rna_structure_bootstrap.png");
	}
	
	template<> QIcon BootstrapData<profdist::protein_traits>::icon() const
	{
		return QIcon(":images/64x64/protein_bootstrap.png");
	}
	
	template<> QString BootstrapData<profdist::rna_traits>::info() const
	{
		return QString().setNum(numBootstraps()) + QObject::tr(" RNA/DNA Bootstraps");
	}
	
	template<> QString BootstrapData<profdist::rna_structure_traits>::info() const
	{
		return QString().setNum(numBootstraps()) + QObject::tr(" RNA/DNA Structure Bootstraps");
	}
	
	template<> QString BootstrapData<profdist::protein_traits>::info() const
	{
		return QString().setNum(numBootstraps()) + QObject::tr(" Protein Bootstraps");
	}
	
}
